
#pragma once

#include <cstdlib>
#include <torch/extension.h>

inline bool parseEnvVarFlag(const char* envVarName) {
  char* stringValue = std::getenv(envVarName);
  if (stringValue != nullptr) {
    int val;
    try {
      val = std::stoi(stringValue);
    } catch (std::exception& e) {
      TORCH_CHECK(false,
          "Invalid value for environment variable: " + std::string(envVarName));
    }
    if (val == 1) {
      return true;
    } else if (val == 0) {
      return false;
    } else {
      TORCH_CHECK(false,
          "Invalid value for environment variable: " + std::string(envVarName));
    }
  }
  return false;
}