# APEX

## 介绍

[Introduction](README_ORIGIN.md)

### APEX 简介

DAS软件栈提供DCU适配版的apex深度学习框架。得益于DAS软件栈对apex特性功能的支持，开发者针对DCU加速卡开发应用时，可以便捷调用apex用于简化Pytorch中的混合精度和分布式训练等功能

### 适配环境

```shell
DTK: dtk-25.04
pytorch: 2.4.1
torch-mocker: v2.4
```
#### 安装mocker和torch
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[http://10.6.10.68:8000/debug/pytorch/dtk24.04.1/](http://10.6.10.68:8000/debug/pytorch/dtk24.04.1/)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch*(下载的torch的whl包)
pip install fastpt* (下载的fastpt的whl包, 安装顺序， 先安装torch，后安装fastpt)
pip install setuptools==59.5.0 wheel
```
#### 设置环境变量
```shell
source /opt/dtk/cuda/env.sh
export LD_LIBRARY_PATH=/usr/local/lib/python3.10/site-packages/torch/lib:$LD_LIBRARY_PATH
export USE_FASTPT_CUDA=1
```

### 前置条件
使用 DAS PyTorch需要参考[《DCU新手入门教程》](https://developer.hpccube.com/gitbook//dcu_tutorial/index.html)在主机系统安装以下组件:
- DCU驱动程序
- DTK
- Docker引擎

### 使用命令安装
工具安装使用 pip 方式，从http://10.6.10.68:8000/debug/apex/dtk25.04-rc2/下载此工具的安装包。注意与 python，torch 版本匹配

`pip3 install apex-xxx.whl`


### 使用源码安装

#### 下载源码：
```shell
http://developer.sourcefind.cn/codes/OpenDAS/apex.git
```
#### 源码编译:
```shell
cd apex

git branch -a  # 查看所有分支

git checkout 24.04.1-dtk25.04 # 切换到分支

python3 setup.py --cpp_ext --cuda_ext --peer_memory --nccl_p2p --fast_bottleneck bdist_wheel # 编译指令

pip install dist/apex* # 安装apex
```
