# APEX

## 介绍

[Introduction](README_ORIGIN.md)

### APEX 简介

DAS软件栈提供DCU适配版的apex深度学习框架。得益于DAS软件栈对apex特性功能的支持，开发者针对DCU加速卡开发应用时，可以便捷调用apex用于简化Pytorch中的混合精度和分布式训练等功能

### 适配环境

```shell
DTK: dtk-25.04-rc4
pytorch: 2.4.1
torch-mocker: v2.4

# 环境初始化脚本
source /opt/dtk-25.04-rc4/env.sh
source /opt/dtk-25.04-rc4/cuda/env.sh
export LD_LIBRARY_PATH=/usr/local/lib/python3.10/site-packages/torch/lib:$LD_LIBRARY_PATH
export TORCH_PATH=/usr/local/lib/python3.10/site-packages/torch
export HIP_TORCH_PATH=/home/pytorch-2.4.1-dev
export USE_FASTPT_CUDA=True # 如果pytorch中没有这个宏，则需要手动关闭HIP转码
```

### 前置条件
使用 DAS PyTorch需要参考[《DCU新手入门教程》](https://developer.hpccube.com/gitbook//dcu_tutorial/index.html)在主机系统安装以下组件:
- DCU驱动程序
- DTK
- Docker引擎

### 使用命令安装
工具安装使用 pip 方式，从http://10.6.10.68:8000/debug/apex/dtk25.04-rc2/下载此工具的安装包。注意与 python，torch 版本匹配

`pip3 install apex-xxx.whl`


### 使用源码安装

- 代码路径：https://github.com/NVIDIA/apex/tree/24.04.01-devel

  ```bash
  git clone https://github.com/NVIDIA/apex.git
  cd apex
  
  # 查看所有分支
  git branch -a
  
  # 切换到分支 remotes/origin/24.04.01-devel
  git checkout remotes/origin/24.04.01-devel
  
  # 创建开发分支
  git switch -c jr_apex_dev
  
  # 编译指令
  python3 setup.py --cpp_ext --cuda_ext --peer_memory --nccl_p2p --fast_bottleneck bdist_wheel
  
  # 安装apex
  pip install dist/apex*
  ```


