# EasyR1: An Efficient, Scalable, Multi-Modality RL Training Framework

这个项目是原始[veRL](https://github.com/volcengine/verl)项目的一个干净的分支，以支持视觉语言模型。

EasyR1基于 **[HybirdEngine](https://arxiv.org/abs/2409.19256)** 和最新发布的 **[vLLM](https://github.com/vllm-project/vllm)** 的SPMD模式，是一个高效和可扩展的项目。

## 项目特色

- 支持的模型
  - Qwen2/Qwen2.5 language models
  - Qwen2/Qwen2.5-VL vision language models
  - DeepSeek-R1 distill models

- 支持的算法
  - GRPO
  - Reinforce++
  - ReMax
  - RLOO

- 支持的数据集
  - Any text, vision-text dataset in a [specific format](#custom-dataset).

## 软硬件依赖

### 软件依赖

- Python 3.10+
- transformers>=4.49.0
- flash-attn==2.6.1+das.opt4.dtk2504
- vllm>=0.7.3

### 硬件依赖

\* *估算值*

| Method                   | Bits |  1.5B  |   3B   |   7B   |   32B   |
| ------------------------ | ---- | ------ | ------ | ------ | ------- |
| GRPO Full Fine-Tuning    |  AMP | 2*24GB | 4*40GB | 8*40GB | 16*80GB |
| GRPO Full Fine-Tuning    | BF16 | 1*24GB | 1*40GB | 4*40GB |  8*80GB |

> [!NOTE]
> 使用 `worker.actor.fsdp.torch_dtype=bf16` 和 `worker.actor.optim.strategy=adamw_bf16`参数确保使用 bf16 类型训练。
>
> 我们正在努力减少RL训练中的VRAM，LoRA支持将在下一次更新中集成。

## 教程: 只需三步，在 [Geometry3K](https://huggingface.co/datasets/hiyouga/geometry3k) 数据集上基于GRPO算法训练Qwen2.5-VL。

![image](assets/qwen2_5_vl_7b_geo.png)

### 环境准备

`-v 路径`、`docker_name`和`imageID`根据实际情况修改

####  Docker（方法一）

基于光源pytorch2.4.1+dtk25.04基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch2.4.1、python、dtk及系统下载对应的镜像版本。

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10

docker run -it --shm-size 200g --network=host --name docker_name --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro imageID bash

## 安装所需环境包
cd EasyR1

pip install -r requirements.txt --no-deps
## 注释掉accelerate、liger-kernel、tensordict之后再执行以下步骤
pip install -r requirements.txt
# 编译
pip install -e .
```
#### Dockerfile（方法二）

```bash
cd docker
docker build --no-cache -t llama-factory:latest .
docker run -it --shm-size 200g --network=host --name docker_name --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro imageID bash

## 安装所需环境包
cd EasyR1

pip install -r requirements.txt --no-deps
## 注释掉accelerate、liger-kernel、tensordict之后再执行以下步骤
pip install -r requirements.txt
# 编译
pip install -e .
```

#### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```bash
DTK驱动: dtk25.04
python: 3.10
torch: 2.4.1
deepspeed: 0.14.2+das.opt2.dtk2504
flash-attn: 2.6.1+das.opt4.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

```bash
cd EasyR1

pip install -r requirements.txt --no-deps
## 注释掉accelerate、liger-kernel、tensordict之后再执行以下步骤
pip install -r requirements.txt
# 编译
pip install -e .
```

### GRPO 训练

```bash
bash examples/qwen2_5_7b_math_grpo.sh
```

### 基于Hugging Face Format融合Checkpoint

```bash
python3 scripts/model_merger.py --local_dir path_to_your_last_actor_checkpoint
```

> [!NOTE]

> 如果您想使用SwanLab日志记录器，请考虑使用 `bash examples/qwen2_5_vl_7b_geo3k_swanlab.sh`.

## 自定义数据集

自定义数据集应严格遵循示例数据格式。

- 文本数据集: https://huggingface.co/datasets/hiyouga/math12k
    - Required columns: problem, answer

- 视觉-文本数据集: https://huggingface.co/datasets/hiyouga/geometry3k
    - Required columns: images, problem, answer

## 其他基线

- [CLEVR-70k-Counting](examples/run_qwen2_5_vl_2b_clevr.sh):训练 Qwen2.5-VL-3B-Instruct 模型计数问题。

### 已知问题

这些功能目前暂时禁用，我们计划在未来的更新中逐一修复。

- 视觉语言模型目前不兼容 padding-free 训练和 DeepSpeed Ulysses并行方法。
