# EasyR1: An Efficient, Scalable, Multi-Modality RL Training Framework

这个项目是原始[veRL](https://github.com/volcengine/verl)项目的一个干净的分支，以支持视觉语言模型。

EasyR1基于 **[HybirdEngine](https://arxiv.org/abs/2409.19256)** 和最新发布的 **[vLLM](https://github.com/vllm-project/vllm)** 的SPMD模式，是一个高效和可扩展的项目。

## 项目特色

- 支持的模型
  - Qwen2/Qwen2.5 language models
  - Qwen2/Qwen2.5-VL vision language models
  - DeepSeek-R1 distill models

- 支持的算法
  - GRPO
  - others RL algorithms (comming soon)

- 支持的数据集
  - Any text, vision-text dataset in a [specific format](#custom-dataset).

## 软硬件依赖

### 软件依赖

- Python 3.9+
- transformers>=4.49.0
- flash-attn>=2.4.3
- vllm>=0.7.3

We provide a [Dockerfile](./Dockerfile) to easily build environments.

### 硬件依赖

\* *估算值*

| 方法                     | 精度  |  1.5B  |   3B   |   7B   |
| ------------------------ | ---- | ------ | ------ | ------ |
| GRPO Full Fine-Tuning    |  AMP | 2*24GB | 4*40GB | 8*40GB |

> [!NOTE]
> 我们正在努力减少RL训练中的VRAM， LoRA支持将在下一次更新中集成。

## 教程: 只需三步， 在 [Geometry3K](https://huggingface.co/datasets/hiyouga/geometry3k) 数据集上基于GRPO算法训练Qwen2.5-VL。

![image](assets/qwen2_5_vl_7b_geo.png)

### 如何使用

```bash
git clone https://github.com/hiyouga/EasyR1.git
cd EasyR1
pip install -e .
```

### GRPO 训练

```bash
bash examples/run_qwen2_5_vl_7b_geo.sh
```

### 基于Hugging Face Format融合Checkpoint

```bash
python3 scripts/model_merger.py --local_dir path_to_your_last_actor_checkpoint
```

> [!NOTE]
>如果您在连接“Hugging Face”时遇到问题，请考虑使用 `export HF_ENDPOINT=https://hf-mirror.com`.
>
> 如果您想使用SwanLab日志记录器，请考虑使用 `bash examples/run_qwen2_5_vl_7b_geo_swanlab.sh`.

## 自定义数据集

自定义数据集应严格遵循示例数据格式。

- 文本数据集: https://huggingface.co/datasets/hiyouga/math12k
    - Required columns: problem, answer

- 视觉-文本数据集: https://huggingface.co/datasets/hiyouga/geometry3k
    - Required columns: images, problem, answer

## 其他基线

- [CLEVR-70k-Counting](examples/run_qwen2_5_vl_2b_clevr.sh):训练 Qwen2.5-VL-3B-Instruct 模型计数问题。

### 已知问题

这些功能目前暂时禁用，我们计划在未来的更新中逐一修复。

- 视觉语言模型目前不兼容 padding-free 训练和 DeepSpeed Ulysses并行方法。
- 视觉语言模型目前不兼容 `enable_chunked_prefill` 除非 [vLLM v1](https://blog.vllm.ai/2025/01/27/v1-alpha-release.html) 已支持。

