# EasyR1: An Efficient, Scalable, Multi-Modality RL Training Framework

这个项目是原始[veRL](https://github.com/volcengine/verl)项目的一个干净的分支，以支持视觉语言模型。

EasyR1基于 **[HybirdEngine](https://arxiv.org/abs/2409.19256)** 和最新发布的 **[vLLM](https://github.com/vllm-project/vllm)** 的SPMD模式，是一个高效和可扩展的项目。

## 项目特色

- 支持的模型
  - Qwen2/Qwen2.5 language models
  - Qwen2/Qwen2.5-VL vision language models
  - DeepSeek-R1 distill models

- 支持的算法
  - GRPO
  - Reinforce++
  - ReMax
  - RLOO

- 支持的数据集
  - Any text, vision-text dataset in a [specific format](#custom-dataset).

## 软硬件依赖

### 软件依赖

- Python 3.10+
- transformers>=4.49.0
- flash-attn==2.6.1+das.opt4.dtk2504
- vllm>=0.8.5

### 硬件依赖

\* *估算值*

| Method                   | Bits |  1.5B  |   3B   |   7B   |   32B   |
| ------------------------ | ---- | ------ | ------ | ------ | ------- |
| GRPO Full Fine-Tuning    |  AMP | 2*24GB | 4*40GB | 8*40GB | 16*80GB |
| GRPO Full Fine-Tuning    | BF16 | 1*24GB | 1*40GB | 4*40GB |  8*80GB |

> [!NOTE]
> 使用 `worker.actor.fsdp.torch_dtype=bf16` 和 `worker.actor.optim.strategy=adamw_bf16`参数确保使用 bf16 类型训练。
>
> 训练需要使用到wandb，环境安装结束后，需要先登录wandb。

## 教程: 只需三步，在 [Geometry3K](https://huggingface.co/datasets/hiyouga/geometry3k) 数据集上基于GRPO算法训练Qwen2.5-VL。

![image](assets/qwen2_5_vl_7b_geo.png)

### 环境准备
`-v 路径`、`docker_name`和`imageID`根据实际情况修改

####  Docker（方法一）

基于光源pytorch2.4.1+dtk25.04.1基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch2.4.1、python、dtk及系统下载对应的镜像版本。

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.8.5-ubuntu22.04-dtk25.04.1-rc5-das1.6-py3.10-20250705

docker run -it --shm-size 200g --network=host --name docker_name --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro imageID bash

## 安装所需环境包
cd EasyR1
pip install -r requirements.txt
pip install "tensordict<0.6"
# 编译
pip install -e .
export LLAMA_NN=0
```
#### Dockerfile（方法二）

```bash
cd docker
docker build --no-cache -t easyR1:latest .
docker run -it --shm-size 200g --network=host --name docker_name --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro imageID bash

## 安装所需环境包
cd EasyR1
pip install -r requirements.txt
pip install "tensordict<0.6"
# 编译
pip install -e .
export LLAMA_NN=0
```

#### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```bash
DTK驱动: dtk25.04.1
python: 3.10
torch: 2.4.1+das.opt1.dtk25041
deepspeed: 0.14.2+das.opt1.dtk25041
flash-attn: 2.6.1+das.opt1.dtk25041
vllm: 0.8.5.post1+das.opt2.dtk25041
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

```bash
cd EasyR1
pip install -r requirements.txt
pip install "tensordict<0.6"
# 编译
pip install -e .

## vllm cpu offload
export LLAMA_NN=0
```

### 数据集
可根据下面的样例数据去构造自己的数据集

- Text dataset: https://huggingface.co/datasets/hiyouga/math12k
- Image-text dataset: https://huggingface.co/datasets/hiyouga/geometry3k
- Multi-image-text dataset: https://huggingface.co/datasets/hiyouga/journeybench-multi-image-vqa

### GRPO 训练

如果无法连接到Hugging Face，请先安装`pip install -U huggingface_hub hf_transfer`，再在启动前增加 `export HF_ENDPOINT=https://hf-mirror.com`命令

```bash
bash examples/qwen2_5_vl_7b_geo3k_grpo.sh
```

### 基于Hugging Face Format融合Checkpoint

```bash
python3 scripts/model_merger.py --local_dir path_to_your_actor_checkpoint
```

> [!NOTE]
>
> 如果您想使用SwanLab日志记录器，请考虑使用 `bash examples/qwen2_5_vl_7b_geo3k_swanlab.sh`.

## 自定义数据集

自定义数据集应严格遵循示例数据格式。

- 文本数据集: https://huggingface.co/datasets/hiyouga/math12k
    - Required columns: problem, answer

- 视觉-文本数据集: https://huggingface.co/datasets/hiyouga/geometry3k
    - Required columns: images, problem, answer

## 其他基线

- [CLEVR-70k-Counting](examples/baselines/qwen2_5_vl_3b_clevr.sh):训练 Qwen2.5-VL-3B-Instruct 模型计数问题。
- [GeoQA-8k](examples/baselines/qwen2_5_vl_3b_geoqa8k.sh): 训练Qwen2.5-VL-3B-Instruct 的 GeoQA 问题.

### 已知问题

这些功能目前暂时禁用，我们计划在未来的更新中逐一修复。

- 视觉语言模型目前不兼容 padding-free 训练和 DeepSpeed Ulysses并行方法。

### 常见问题及解决办法

> ValueError: Image features and image tokens do not match: tokens: 8192, features 9800

增大`data.max_prompt_length`的数值或者减小`data.max_pixels` 的数值.

> RuntimeError: CUDA Error: out of memory at /workspace/csrc/cumem_allocator.cpp:62

减小`worker.rollout.gpu_memory_utilization`的数值并且确认开启 `worker.actor.offload.offload_params`.

> RuntimeError: 0 active drivers ([]). There should only be one.

在当前python环境下卸载 `deepspeed`.

> RuntimeError: No HIP GPUs are available

在`~/.bashrc`中新增 `export HIP_VISIBLE_DEVICES=0,1,2,3`，并重新source下环境
