import argparse
import collections
import torch


def convert_vit_transformer_encoder_from_huggingface_to_tencentpretrain(input_model, output_model, layers_num):
    for i in range(layers_num):
        output_model["encoder.transformer." + str(i) + ".self_attn.linear_layers.0.weight"] = \
            input_model["encoder.layer." + str(i) + ".attention.attention.query.weight"]
        output_model["encoder.transformer." + str(i) + ".self_attn.linear_layers.0.bias"] = \
            input_model["encoder.layer." + str(i) + ".attention.attention.query.bias"]
        output_model["encoder.transformer." + str(i) + ".self_attn.linear_layers.1.weight"] = \
            input_model["encoder.layer." + str(i) + ".attention.attention.key.weight"]
        output_model["encoder.transformer." + str(i) + ".self_attn.linear_layers.1.bias"] = \
            input_model["encoder.layer." + str(i) + ".attention.attention.key.bias"]
        output_model["encoder.transformer." + str(i) + ".self_attn.linear_layers.2.weight"] = \
            input_model["encoder.layer." + str(i) + ".attention.attention.value.weight"]
        output_model["encoder.transformer." + str(i) + ".self_attn.linear_layers.2.bias"] = \
            input_model["encoder.layer." + str(i) + ".attention.attention.value.bias"]
        output_model["encoder.transformer." + str(i) + ".self_attn.final_linear.weight"] = \
            input_model["encoder.layer." + str(i) + ".attention.output.dense.weight"]
        output_model["encoder.transformer." + str(i) + ".self_attn.final_linear.bias"] = \
            input_model["encoder.layer." + str(i) + ".attention.output.dense.bias"]
        output_model["encoder.transformer." + str(i) + ".layer_norm_1.gamma"] = \
            input_model["encoder.layer." + str(i) + ".layernorm_before.weight"]
        output_model["encoder.transformer." + str(i) + ".layer_norm_1.beta"] = \
            input_model["encoder.layer." + str(i) + ".layernorm_before.bias"]
        output_model["encoder.transformer." + str(i) + ".feed_forward.linear_1.weight"] = \
            input_model["encoder.layer." + str(i) + ".intermediate.dense.weight"]
        output_model["encoder.transformer." + str(i) + ".feed_forward.linear_1.bias"] = \
            input_model["encoder.layer." + str(i) + ".intermediate.dense.bias"]
        output_model["encoder.transformer." + str(i) + ".feed_forward.linear_2.weight"] = \
            input_model["encoder.layer." + str(i) + ".output.dense.weight"]
        output_model["encoder.transformer." + str(i) + ".feed_forward.linear_2.bias"] = \
            input_model["encoder.layer." + str(i) + ".output.dense.bias"]
        output_model["encoder.transformer." + str(i) + ".layer_norm_2.gamma"] = \
            input_model["encoder.layer." + str(i) + ".layernorm_after.weight"]
        output_model["encoder.transformer." + str(i) + ".layer_norm_2.beta"] = \
            input_model["encoder.layer." + str(i) + ".layernorm_after.bias"]


def main():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("--input_model_path", type=str, default="models/input_model.bin",
                        help=".")
    parser.add_argument("--output_model_path", type=str, default="models/output_model.bin",
                        help=".")
    parser.add_argument("--layers_num", type=int, default=12, help=".")


    args = parser.parse_args()

    input_model = torch.load(args.input_model_path, map_location="cpu")

    output_model = collections.OrderedDict()

    output_model["embedding.patch.cls_emb"] = input_model["embeddings.cls_token"]
    output_model["embedding.patch.projection.weight"] = input_model["embeddings.patch_embeddings.projection.weight"]
    output_model["embedding.patch.projection.bias"] = input_model["embeddings.patch_embeddings.projection.bias"]
    output_model["embedding.pos.embedding.weight"] = input_model["embeddings.position_embeddings"].squeeze(0)

    convert_vit_transformer_encoder_from_huggingface_to_tencentpretrain(input_model, output_model, args.layers_num)

    output_model["encoder.layer_norm.gamma"] = input_model["layernorm.weight"]
    output_model["encoder.layer_norm.beta"] = input_model["layernorm.bias"]
    torch.save(output_model, args.output_model_path)


if __name__ == "__main__":
    main()
