<!-- Thank you for your contribution—we truly appreciate it! To help us review your pull request efficiently, please follow the guidelines below. If anything is unclear, feel free to open the PR and ask for clarification. You can also refer to our [contribution guide](./docs/contribution_guide.md) for more details. -->

## Motivation

<!-- Explain the purpose of this PR and the goals it aims to achieve. -->

## Modifications

<!-- Describe the changes made in this PR. -->

## Checklist

- [ ] Code is formatted using Pre-Commit hooks.
- [ ] Relevant unit tests are added in the [`tests`](../tests) directory following the guidance in [`Contribution Guide`](https://nunchaku.tech/docs/nunchaku/developer/contribution_guide.html).
- [ ] [Documentation](../docs/source) and example scripts in [`examples`](../examples) are updated if necessary.
- [ ] Throughput/latency benchmarks and quality evaluations are included where applicable.
- [ ] **For reviewers:** If you're only helping merge the main branch and haven't contributed code to this PR, please remove yourself as a co-author when merging.
- [ ] Please feel free to join our [Slack](https://join.slack.com/t/nunchaku/shared_invite/zt-3170agzoz-NgZzWaTrEj~n2KEV3Hpl5Q), [Discord](https://discord.gg/Wk6PnwX9Sm) or [WeChat](https://huggingface.co/datasets/nunchaku-tech/cdn/blob/main/nunchaku/assets/wechat.jpg) to discuss your PR.
