# AnimateDiff-Lightning

## 论文

**AnimateDiff-Lightning: Cross-Model Diffusion Distillation**

* https://arxiv.org/abs/2403.12706

## 模型结构

模型由多个不同的基础`AnimateDiff`模型组成（不同`stable diffusion`模型），其中`motion module`为可训练的共享模块，`Base module`为不可训练的独立模块。

![alt text](readme_imgs/image-1.png)


## 算法原理

该算法为蒸馏`distillation`算法，通过渐进式的蒸馏方式，将`Teacher`（教师模型）的知识（能力）转移至`Student`（学生模型），同时使用了对抗蒸馏的方法对采样质量和模型收敛性进行了平衡。

![alt text](readme_imgs/image-2.png)


## 环境配置

### Docker（方法一）

    docker pull image.sourcefind.cn:5000/dcu/admin/base/dtk:23.10-ubuntu20.04-py310

    docker run --shm-size 10g --network=host --name=ad_lightning --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install torch-2.1.0a0%2Bgit793d2b5.abi0.dtk2310-cp310-cp310-manylinux2014_x86_64.whl  (whl.zip文件中)

    pip install torchvision-0.16.0+git267eff6.abi0.dtk2310.torch2.1.0-cp310-cp310-linux_x86_64.whl  (whl.zip文件中)

    cd xformers && pip install xformers==0.0.23 --no-deps && bash patch_xformers.rocm.sh  （whl.zip文件中）

    pip install -r requirements.txt

    git clone https://github.com/comfyanonymous/ComfyUI.git 

    cd ComfyUI

    pip install -r requirements.txt

    cd custom_nodes && git clone https://github.com/Kosinkadink/ComfyUI-AnimateDiff-Evolved && git clone https://github.com/Kosinkadink/ComfyUI-VideoHelperSuite && git clone https://github.com/Kosinkadink/ComfyUI-Advanced-ControlNet && git clone https://github.com/Fannovel16/comfyui_controlnet_aux

    apt-get update && apt-get install ffmpeg


注意：所有github库都可手动下载并放入相应的位置。


### Dockerfile（方法二）

    # 需要在对应的目录下
    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 10g --network=host --name=ad_lightning --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install torch-2.1.0a0%2Bgit793d2b5.abi0.dtk2310-cp310-cp310-manylinux2014_x86_64.whl  (whl.zip文件中)

    pip install torchvision-0.16.0+git267eff6.abi0.dtk2310.torch2.1.0-cp310-cp310-linux_x86_64.whl  (whl.zip文件中)

    pip install -r requirements.txt

    git clone https://github.com/comfyanonymous/ComfyUI.git 

    cd ComfyUI

    pip install -r requirements.txt

    cd custom_nodes && git clone https://github.com/Kosinkadink/ComfyUI-AnimateDiff-Evolved && git clone https://github.com/Kosinkadink/ComfyUI-VideoHelperSuite && git clone https://github.com/Kosinkadink/ComfyUI-Advanced-ControlNet && git clone https://github.com/Fannovel16/comfyui_controlnet_aux

    apt-get update && apt-get install ffmpeg


注意：所有github库都可手动下载并放入相应的位置。


### Anaconda (方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk23.10.1
    python：python3.10
    torch:2.1.0
    torchvision:0.16.0

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install torch-2.1.0a0%2Bgit793d2b5.abi0.dtk2310-cp310-cp310-manylinux2014_x86_64.whl  (whl.zip文件中)

    pip install torchvision-0.16.0+git267eff6.abi0.dtk2310.torch2.1.0-cp310-cp310-linux_x86_64.whl  (whl.zip文件中)

    pip install -r requirements.txt

    git clone https://github.com/comfyanonymous/ComfyUI.git 

    cd ComfyUI

    pip install -r requirements.txt

    cd custom_nodes && git clone https://github.com/Kosinkadink/ComfyUI-AnimateDiff-Evolved && git clone https://github.com/Kosinkadink/ComfyUI-VideoHelperSuite && git clone https://github.com/Kosinkadink/ComfyUI-Advanced-ControlNet && git clone https://github.com/Fannovel16/comfyui_controlnet_aux

    conda install -c conda-forge ffmpeg
    

## 数据集

无

## 推理

### 模型下载

https://huggingface.co/ByteDance/AnimateDiff-Lightning/tree/main

|名称+url|save_path|类型|
|:---|:---|:---|
|[1step](https://huggingface.co/ByteDance/AnimateDiff-Lightning/blob/main/animatediff_lightning_1step_comfyui.safetensors)|ComfyUI/custom_nodes/ComfyUI-AnimateDiff-Evolved/models/|运动模块|
|[2step](https://huggingface.co/ByteDance/AnimateDiff-Lightning/blob/main/animatediff_lightning_2step_comfyui.safetensors)|ComfyUI/custom_nodes/ComfyUI-AnimateDiff-Evolved/models/|运动模块|
|[4step](https://huggingface.co/ByteDance/AnimateDiff-Lightning/blob/main/animatediff_lightning_4step_comfyui.safetensors)|ComfyUI/custom_nodes/ComfyUI-AnimateDiff-Evolved/models/|运动模块|
|[8step](https://huggingface.co/ByteDance/AnimateDiff-Lightning/blob/main/animatediff_lightning_8step_comfyui.safetensors)|ComfyUI/custom_nodes/ComfyUI-AnimateDiff-Evolved/models/|运动模块|
|[emilianJR/epiCRealism](https://civitai.com/models/25694/epicrealism)|ComfyUI/models/checkpoints|基础模型|
|[XXMix_9realistic](https://civitai.com/models/47274/xxmix9realistic?modelVersionId=102222)|ComfyUI/models/checkpoints|基础模型|

以上模型可以按需下载，并放入相应的路径。这里仅列出部分基础模型，可以下载其他模型（sd1.5）使用，运动模块选择一个即可。

除了手动下载这些模型并在`ComfyUI`中使用，也可以使用`diffuser`自动下载并以代码的方式调用。

注意：可以使用`https://hf-mirror.com`加速下载相应的模型权重。


### 命令行

    # export HF_ENDPOINT=https://hf-mirror.com （按需）

    # 快速测试
    python scripts/quick_inference.py --step [1 2 4 8] --prompt <your prompt>

### ComfyUI（建议）

    cd ComfyUI

    HIP_VISIBLE_DEVICES=0 python main.py --listen=0.0.0.0 --port=12341

注意：关于ComfyUI的使用方法需自行学习，`comfyui_workflow`中提供了示例工作流，可在UI界面中加载使用。

## result

prompt: Red hair girl, red eyes, long hair, childish, white clothes, in a green grass field with a blue cloud sky, anime style, cute, smiling

seed: 99999

base model: Ether Real Mix


|||1step|2step|4step|8step|
|:---:|:---:|:---:|:---:|:---:|:---:|
|time||<1s|2s|6s|14s|
|结果||![alt text](readme_imgs/AnimateDiff_00023.gif)|![alt text](readme_imgs/AnimateDiff_00024.gif)|![alt text](readme_imgs/AnimateDiff_00020.gif)|![alt text](readme_imgs/AnimateDiff_00022.gif)|


### 精度

无

## 应用场景

### 算法类别

`AIGC`

### 热点应用行业

`媒体,科研,教育`

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/animatediff-lightning_pytorch

## 参考资料

* https://huggingface.co/ByteDance/AnimateDiff-Lightning
